<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

	if (is_dir("modules/skineditor/updates/skins/")) {	


		$dir = new CDir("modules/skineditor/updates/skins/" , ".xml" , false);

		if (is_array($dir->_files) && count($dir->_files)) {
			foreach ($dir->_files as $key => $val) {

				$skin = new CConfig($val);

				//insert in database
				$sid = $this->db->QueryInsert(
					$this->tables["core:skins"],
					array(
						"skin_css"	=> $skin->vars["skin"]["content"],
						"skin_name"	=> $skin->vars["skin"]["name"],
						"skin_base"	=> $skin->vars["skin"]["base"],
					)
				);

				//save the files in the skinds folder
				CFile::Save("../upload/skins/{$sid}.css" , $skin->vars["skin"]["content"]);
/*
				if ($skin->vars["skin"]["default"] == "true") {
					$this->vars->SetVars(array(
						"set_skin"	=> $sid
					));
				}		
*/				
			}			
		}
	}		




$vars = array(
	"cookie_text"	=> "We use cookies to give the best experience to our visitors. By using this website, you're agreeing to our use of cookies.",
	"cookie_btn_accept"	=> "ACCEPT",
	"cookie_btn_more"	=> "READ MORE",
);


foreach ($vars as $key => $val) {

	$this->db->QueryInsert(
		$this->tables["core:languages_vars_lang"],
		array(
			"var_id"	=> $this->db->QueryInsert(
				$this->tables["core:languages_vars"],
				array(
					"var_name"	=> strtoupper($key),
				)
			),

			"lang_id"	=> "1",
			"var_value"	=> $val,
		)
	);
}